/*
 * @(#)DraggableMessageFigureBsh.java  1.0  31. M�rz 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagrambsh;

import ch.hslu.cm.oo.*;
import ch.hslu.cm.oo.objectmodel.*;
import org.jhotdraw.draw.TextFigure;
import java.awt.geom.*;
import java.awt.font.*;
import java.util.*;
import java.io.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.geom.Geom;
/**
 * DraggableMessageFigureBsh holds a message, which can be sent to an object,
 * by dragging the DraggableMessageFigureBsh onto a {@link ObjectFigureBsh}.
 *
 * @author  Werner Randelshofer
 * @version 1.0 31. M�rz 2004  Created.
 */
public class DraggableMessageFigureBsh extends TextFigure {
    private final static double ovalGrowFactor = Math.sqrt(2.0) / 7.0;
    
    /** Creates a new instance. */
    public DraggableMessageFigureBsh() {
        super("Nachricht");
        FILL_COLOR.set(this, ClassDiagram.MESSAGE_FILL_COLOR);
        STROKE_COLOR.set(this, ClassDiagram.MESSAGE_STROKE_COLOR);
    }
    
    public String getOperationName() {
        String text = getText().trim();
        int p = text.indexOf('(');
        return (p == -1) ? text : text.substring(0, p);
    }
    
    /**
     * Returns the argument list of the operation.
     * <pre>
     * operation ::= operationName [ '(' argumentList ')' ]
     * argumentList = argument [ ',' argumentList ]
     * operationName ::= WORD
     * argument ::= WORD | NUMBER | STRING
     * </pre>
     *
     * @return Returns null if no arguments are specified.
     */
    public Object[] getArguments(ObjectModel sim) throws IOException {
        StreamTokenizer tt = new StreamTokenizer(new StringReader(getText().trim()));
        tt.wordChars('_', '_');
        
        
        // Parse operationName. Fail if it is missing.
        if (tt.nextToken() != StreamTokenizer.TT_WORD) return null;
        
        // Parse '('. Fail if it is missing.
        if (tt.nextToken() != '(') return null;
        
        ArrayList<Object> arguments = new ArrayList<Object>();
        while (tt.nextToken() != ')') {
            switch (tt.ttype) {
                case StreamTokenizer.TT_WORD :
                    if (tt.sval.equals("null")) {
                        arguments.add(null);
                    } else if (tt.sval.equals("this")) {
                        throw new IOException("'this' ist nicht zulässig");
                    } else if (tt.sval.equals("super")) {
                        throw new IOException("'super' ist nicht zulässig");
                    } else {
                        // FIXME suche in Simulation nach Element mit dem angegebenen Namen
                        OMObject obj =sim.getSimulatedObject(tt.sval);
                        if (obj == null) {
                        throw new IllegalArgumentException("Es gibt kein Objekt mit dem Namen '"+tt.sval+"'");
                        } else {
                            arguments.add(obj);
                        }
                        break;
                    }
                    break;
                case StreamTokenizer.TT_NUMBER :
                    arguments.add(new Double(tt.nval));
                    break;
                case '"' :
                case '\'' :
                    arguments.add(tt.sval);
                    break;
                default :
                    throw new IOException("Objektreferenz noch nicht implementiert, Sorry.");
            }
            switch (tt.nextToken()) {
                case ')' :
                    tt.pushBack();
                    break;
                case ',' :
                    break;
                default :
                    throw new IOException("Kann Argumentliste nicht interpretieren.");
                    
            }
        }
        return arguments.toArray();
    }
    
    protected void drawStroke(java.awt.Graphics2D g) {
        Rectangle2D.Double r = getEllipseBounds();
        double arc=Math.min(r.width,r.height);
        RoundRectangle2D.Double e = new RoundRectangle2D.Double(r.x, r.y, r.width, r.height,arc,arc);
        g.draw(e);
    }
    protected void drawFill(java.awt.Graphics2D g) {
        Rectangle2D.Double r = getEllipseBounds();
        double arc=Math.min(r.width,r.height);
        RoundRectangle2D.Double e = new RoundRectangle2D.Double(r.x, r.y, r.width, r.height,arc,arc);
        g.fill(e);
    }
    protected Rectangle2D.Double getEllipseBounds() {
        TextLayout layout = getTextLayout();
        Rectangle2D.Double r = new Rectangle2D.Double(origin.x, origin.y, (int) layout.getAdvance(), (int) (layout.getAscent() + layout.getDescent()));
        
        // Returns an oval which encloses the text bounds and has
        // the same aspect as the rectangle.
        double growx = Math.min(r.width,r.height)/2;
        double growy = 0;
        Geom.grow(r, growx, growy);
        return r;
    }
    
    @Override
    public Rectangle2D.Double getFigureDrawingArea() {
        Rectangle2D.Double r = getEllipseBounds();
        if (STROKE_COLOR.get(this) != null) {
            double grow = STROKE_WIDTH.get(this) / 2 + 1;
            r.x -= grow;
            r.y -= grow;
            r.width += grow * 2;
            r.height += grow * 2;
        }
        return r;
    }
    public boolean figureContains(Point2D.Double p) {
        Rectangle2D.Double r = getEllipseBounds();
        //new Ellipse2D.Float(r.x, r.y, r.width, r.height).contains(x, y);
        if (r.width <= 0 || r.height <= 0) {
            return false;
        }
        double normx = (p.x - r.x) / (double) r.width - 0.5;
        double normy = (p.y - r.y) / (double) r.height - 0.5;
        return (normx * normx + normy * normy) < 0.25;
    }
    public int getLayer() {
        return ClassDiagram.MESSAGE_LAYER;
    }
}
